

<?php $__env->startSection('page-header'); ?>
	<!-- PAGE HEADER -->
	<div class="page-header mt-5-7">
		<div class="page-leftheader">
			<h4 class="page-title mb-0"><?php echo e(__('Payment Settings')); ?></h4>
			<ol class="breadcrumb mb-2">
				<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa-solid fa-sack-dollar mr-2 fs-12"></i><?php echo e(__('Admin')); ?></a></li>
				<li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.finance.dashboard')); ?>"> <?php echo e(__('Finance Management')); ?></a></li>
				<li class="breadcrumb-item active" aria-current="page"><a href="<?php echo e(url('#')); ?>"> <?php echo e(__('Payment Settings')); ?></a></li>
			</ol>
		</div>
	</div>
	<!-- END PAGE HEADER -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>	
	<!-- ALL PAYMENT CONFIGURATIONS -->					
	<div class="row">
		<?php if($type == 'Regular License' && $status): ?>
			<div class="row text-center justify-content-center">
				<p class="fs-14" style="background:#FFE2E5; color:#ff0000; padding:1rem 2rem; border-radius: 0.5rem; max-width: 1200px;"><?php echo e(__('Extended License is required in order to have access to these features')); ?></p>
			</div>	
		<?php else: ?>
			<div class="col-lg-9 col-md-12 col-xm-12">

				<form action="<?php echo e(route('admin.finance.settings.store')); ?>" method="POST" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>

					<div class="card border-0">
						<div class="card-header">
							<h3 class="card-title"><?php echo e(__('Setup Payment Settings')); ?></h3>
						</div>		
						<div class="card-body">				

							<div class="row">
								<div class="col-lg-6 col-md-6 col-sm-12">			
									<div class="input-box">	
										<h6><?php echo e(__('Default Currency')); ?> <span class="text-muted">(<?php echo e(__('Payments/Plans/System/Payouts')); ?>)</span></h6>
										<select id="currency" name="currency" class="form-select" data-placeholder="Choose Default Currency:">			
											<?php $__currentLoopData = config('currencies.all'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($key); ?>" <?php if(config('payment.default_system_currency') == $key): ?> selected <?php endif; ?>><?php echo e($value['name']); ?> - <?php echo e($key); ?> (<?php echo $value['symbol']; ?>)</option>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</select>									
										<?php $__errorArgs = ['currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
											<p class="text-danger"><?php echo e($errors->first('currency')); ?></p>
										<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
									</div> 						
								</div>

								<div class="col-lg-6 col-md-6 col-sm-12">
									<div class="input-box">								
										<h6><?php echo e(__('Tax Rate')); ?> (%)</h6>
										<div class="form-group">							    
											<input type="text" class="form-control <?php $__errorArgs = ['tax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="tax" name="tax" placeholder="Enter Tax Rate" value="<?php echo e(config('payment.payment_tax')); ?>">
										</div>
										<?php $__errorArgs = ['tax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
											<p class="text-danger"><?php echo e($errors->first('tax')); ?></p>
										<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> 
									</div>							
								</div>	
								
								<div class="col-lg-6 col-md-6 col-sm-12">
									<div class="input-box">
										<h6><?php echo e(__('Decimal Points in Prices')); ?> <span class="text-muted">(<?php echo e(__('.00')); ?>)</span> <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
										<select id="chat-feature-user" name="decimal-points" class="form-select" data-placeholder="<?php echo e(__('Allow/Deny Decimal Points in Prices')); ?>">
											<option value='allow' <?php if(config('payment.decimal_points') == 'allow'): ?> selected <?php endif; ?>><?php echo e(__('Allow')); ?></option>
											<option value='deny' <?php if(config('payment.decimal_points') == 'deny'): ?> selected <?php endif; ?>> <?php echo e(__('Deny')); ?></option>																															
										</select>
									</div>
								</div>
							</div>
						
						</div>
					</div>

					<div class="card border-0">
						<div class="card-header">
							<h3 class="card-title"><span class="text-info"><?php echo e(__('Online')); ?> </span> <?php echo e(__('Payment')); ?></h3>
						</div>
						<div class="card-body pb-6">

							<div class="card border-0 special-shadow">							
								<div class="card-body">
									<h6 class="fs-12 font-weight-bold mb-4"><i class="fa-brands fa-cc-paypal fs-16 mr-2"></i><span class="text-primary">Paypal</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>
									
									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-paypal" class="custom-switch-input" <?php if(config('services.paypal.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description"><?php echo e(__('Use PayPal Prepaid')); ?></span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-paypal-subscription" class="custom-switch-input" <?php if(config('services.paypal.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description"><?php echo e(__('Use Paypal Subscription')); ?></span>
												</label>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<div class="input-box">								
												<h6><?php echo e(__('PayPal Client ID')); ?> <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paypal_client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paypal_client_id" name="paypal_client_id" value="<?php echo e(config('services.paypal.client_id')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['paypal_client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paypal_client_id')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6><?php echo e(__('PayPal Client Secret')); ?> <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paypal_client_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paypal_client_secret" name="paypal_client_secret" value="<?php echo e(config('services.paypal.client_secret')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['paypal_client_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paypal_client_secret')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6><?php echo e(__('Paypal Webhook URI')); ?> <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paypal_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paypal_webhook_uri" name="paypal_webhook_uri" value="<?php echo e(config('services.paypal.webhook_uri')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['paypal_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paypal_webhook_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6><?php echo e(__('Paypal Webhook ID')); ?> <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paypal_webhook_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paypal_webhook_id" name="paypal_webhook_id" value="<?php echo e(config('services.paypal.webhook_id')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['paypal_webhook_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paypal_webhook_id')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6><?php echo e(__('PayPal Base URI')); ?> <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<select id="paypal-url" name="paypal_base_uri" class="form-select" data-placeholder="<?php echo e(__('Choose Payment Option')); ?>:">			
													<option value="https://api-m.paypal.com" <?php if(config('services.paypal.base_uri')  == 'https://api-m.paypal.com'): ?> selected <?php endif; ?>>Live URL</option>
													<option value="https://api-m.sandbox.paypal.com" <?php if(config('services.paypal.base_uri')  == 'https://api-m.sandbox.paypal.com'): ?> selected <?php endif; ?>>Sandbox URL</option>
												</select>
												<?php $__errorArgs = ['paypal_base_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paypal_base_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
									
									</div>
		
								</div>
							</div>	


							<div class="card overflow-hidden border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><i class="fa-brands fa-cc-stripe fs-16 mr-2"></i><span class="text-primary">Stripe</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-stripe" class="custom-switch-input" <?php if(config('services.stripe.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description"><?php echo e(__('Use Stripe Prepaid')); ?></span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-stripe-subscription" class="custom-switch-input" <?php if(config('services.stripe.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description"><?php echo e(__('Use Stripe Subscription')); ?></span>
												</label>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Stripe Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['stripe_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="stripe_key" name="stripe_key" value="<?php echo e(config('services.stripe.api_key')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['stripe_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('stripe_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<!-- SECRET ACCESS KEY -->
											<div class="input-box">								
												<h6>Stripe Secret Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['stripe_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="stripe_secret_key" name="stripe_secret_key" value="<?php echo e(config('services.stripe.api_secret')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['stripe_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('stripe_secret_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END SECRET ACCESS KEY -->
										</div>	
										
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Stripe Webhook URI <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['stripe_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="stripe_webhook_uri" name="stripe_webhook_uri" value="<?php echo e(config('services.stripe.webhook_uri')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['stripe_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('stripe_webhook_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Stripe Webhook Secret <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['stripe_webhook_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="stripe_webhook_secret" name="stripe_webhook_secret" value="<?php echo e(config('services.stripe.webhook_secret')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['stripe_webhook_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('stripe_webhook_secret')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Stripe Base URI <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['stripe_base_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="stripe_base_uri" name="stripe_base_uri" value="<?php echo e(config('services.stripe.base_uri')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['stripe_base_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('stripe_base_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
									</div>
		
								</div>
							</div>


							<div class="card overflow-hidden border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/paystack.svg')); ?>" alt="Paystack" class="gateway-logo"><span class="text-primary">Paystack</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-paystack" class="custom-switch-input" <?php if(config('services.paystack.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Paystack Prepaid</span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-paystack-subscription" class="custom-switch-input" <?php if(config('services.paystack.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Paystack Subscription</span>
												</label>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Paystack Public Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paystack_public_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paystack_public_key" name="paystack_public_key" value="<?php echo e(config('services.paystack.api_key')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['paystack_public_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paystack_public_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<!-- SECRET ACCESS KEY -->
											<div class="input-box">								
												<h6>Paystack Secret Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paystack_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paystack_secret_key" name="paystack_secret_key" value="<?php echo e(config('services.paystack.api_secret')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['paystack_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paystack_secret_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END SECRET ACCESS KEY -->
										</div>	
										
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Paystack Webhook URI <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paystack_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paystack_webhook_uri" name="paystack_webhook_uri" value="<?php echo e(config('services.paystack.webhook_uri')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['paystack_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paystack_webhook_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Paystack Base URI <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paystack_base_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paystack_base_uri" name="paystack_base_uri" value="<?php echo e(config('services.paystack.base_uri')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['paystack_base_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('stripe_base_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
									</div>
		
								</div>
							</div>


							<div class="card overflow-hidden border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/razorpay.svg')); ?>" alt="Razorpay" class="gateway-logo"><span class="text-primary">Razorpay</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-razorpay" class="custom-switch-input" <?php if(config('services.razorpay.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Razorpay Prepaid</span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-razorpay-subscription" class="custom-switch-input" <?php if(config('services.razorpay.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Razorpay Subscription</span>
												</label>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Razorpay Key ID <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['razorpay_key_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="razorpay_key_id" name="razorpay_key_id" value="<?php echo e(config('services.razorpay.key_id')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['razorpay_key_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('razorpay_key_id')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<!-- SECRET ACCESS KEY -->
											<div class="input-box">								
												<h6>Razorpay Key Secret <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['razorpay_key_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="razorpay_key_secret" name="razorpay_key_secret" value="<?php echo e(config('services.razorpay.key_secret')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['razorpay_key_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('razorpay_key_secret')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END SECRET ACCESS KEY -->
										</div>	
										
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Razorpay Webhook URI <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['razorpay_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="razorpay_webhook_uri" name="razorpay_webhook_uri" value="<?php echo e(config('services.razorpay.webhook_uri')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['razorpay_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('razorpay_webhook_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Razorpay Webhook Secret <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['razorpay_webhook_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="razorpay_webhook_secret" name="razorpay_webhook_secret" value="<?php echo e(config('services.razorpay.webhook_secret')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['razorpay_webhook_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('razorpay_webhook_secret')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Razorpay Base URI <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['razorpay_base_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="razorpay_base_uri" name="razorpay_base_uri" value="<?php echo e(config('services.razorpay.base_uri')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['razorpay_base_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('razorpay_base_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
									</div>
		
								</div>
							</div>


							<div class="card border-0 special-shadow">							
								<div class="card-body">
		
									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/mollie.svg')); ?>" alt="Mollie" class="gateway-logo gateway-small-logo"><span class="text-primary">Mollie</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>
		
									<div class="row">
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-mollie" class="custom-switch-input" <?php if(config('services.mollie.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Mollie Prepaid</span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-mollie-subscription" class="custom-switch-input" <?php if(config('services.mollie.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Mollie Subscription</span>
												</label>
											</div>
										</div>
									</div>
		
									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Mollie Public Key</h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['mollie_key_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="mollie_key_id" name="mollie_key_id" value="<?php echo e(config('services.mollie.key_id')); ?>" autocomplete="off">
												</div>
													<?php $__errorArgs = ['mollie_key_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('mollie_key_id')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<div class="input-box">								
												<h6>Mollie Webhook URI</h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['mollie_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="mollie_webhook_uri" name="mollie_webhook_uri" value="<?php echo e(config('services.mollie.webhook_uri')); ?>" autocomplete="off">
												</div>
													<?php $__errorArgs = ['mollie_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('mollie_webhook_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div>
										</div>
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<div class="input-box">								
												<h6>Mollie Base URI</h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['mollie_base_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="mollie_base_uri" name="mollie_base_uri" value="<?php echo e(config('services.mollie.base_uri')); ?>" autocomplete="off">
												</div>
													<?php $__errorArgs = ['mollie_base_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('mollie_base_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div>
										</div>								
										
									</div>
		
								</div>
							</div>

							<div class="card border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/flutterwave.svg')); ?>" alt="Midtrans" class="gateway-logo"><span class="text-primary">Flutterwave</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-flutterwave" class="custom-switch-input" <?php if(config('services.flutterwave.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Flutterwave Prepaid</span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-flutterwave-subscription" class="custom-switch-input" <?php if(config('services.flutterwave.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Flutterwave Subscription</span>
												</label>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Flutterwave Puplic Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['flutterwave_public_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="flutterwave_public_key" name="flutterwave_public_key" value="<?php echo e(config('services.flutterwave.public_key')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['flutterwave_public_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('flutterwave_public_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<!-- SECRET ACCESS KEY -->
											<div class="input-box">								
												<h6>Flutterwave Secret Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['flutterwave_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="flutterwave_secret_key" name="flutterwave_secret_key" value="<?php echo e(config('services.flutterwave.secret_key')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['flutterwave_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('flutterwave_secret_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END SECRET ACCESS KEY -->
										</div>	
										
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Flutterwave Webhook URL <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['flutterwave_webhook_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="flutterwave_webhook_url" name="flutterwave_webhook_url" value="<?php echo e(config('services.flutterwave.webhook_url')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['flutterwave_webhook_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('flutterwave_webhook_url')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Flutterwave Secret Hash <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['flutterwave_secret_hash'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="flutterwave_secret_hash" name="flutterwave_secret_hash" value="<?php echo e(config('services.flutterwave.secret_hash')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['flutterwave_secret_hash'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('flutterwave_secret_hash')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
									</div>
		
								</div>
							</div>


							<div class="card border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/yookassa.svg')); ?>" alt="Midtrans" class="gateway-logo"><span class="text-primary">Yookassa</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-yookassa" class="custom-switch-input" <?php if(config('services.yookassa.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Yookassa Prepaid</span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-yookassa-subscription" class="custom-switch-input" <?php if(config('services.yookassa.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Yookassa Subscription</span>
												</label>
											</div>
									</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">
											<!-- SECRET ACCESS KEY -->
											<div class="input-box">								
												<h6>Yookassa Shop ID <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['yookassa_shop_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="yookassa_shop_id" name="yookassa_shop_id" value="<?php echo e(config('services.yookassa.shop_id')); ?>" autocomplete="off">
												</div>
												<?php $__errorArgs = ['yookassa_shop_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('yookassa_shop_id')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END SECRET ACCESS KEY -->
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Yookassa Secret Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['yookassa_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="yookassa_secret_key" name="yookassa_secret_key" value="<?php echo e(config('services.yookassa.secret_key')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['yookassa_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('yookassa_secret_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>										
										
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Yookassa HTTP Notifications <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['yookassa_http_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="yookassa_http_uri" name="yookassa_http_uri" value="<?php echo e(config('services.yookassa.http_uri')); ?>" autocomplete="off">
												</div>
												<?php $__errorArgs = ['yookassa_http_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('yookassa_http_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
									</div>
		
								</div>
							</div>


							<div class="card border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/paddle.webp')); ?>" alt="Midtrans" class="gateway-logo"><span class="text-primary">Paddle</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-paddle" class="custom-switch-input" <?php if(config('services.paddle.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Paddle Prepaid</span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-paddle-subscription" class="custom-switch-input" <?php if(config('services.paddle.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Paddle Subscription</span>
												</label>
											</div>
									</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">
											<!-- SECRET ACCESS KEY -->
											<div class="input-box">								
												<h6>Paddle Vendor ID <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paddle_vendor_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paddle_vendor_id" name="paddle_vendor_id" value="<?php echo e(config('services.paddle.vendor_id')); ?>" autocomplete="off">
												</div>
												<?php $__errorArgs = ['paddle_vendor_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paddle_vendor_id')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END SECRET ACCESS KEY -->
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Paddle Vendor Auth Code <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['paddle_vendor_auth_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="paddle_vendor_auth_code" name="paddle_vendor_auth_code" value="<?php echo e(config('services.paddle.vendor_auth_code')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['paddle_vendor_auth_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paddle_vendor_auth_code')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>										

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Paddle Sandbox <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<select id="paddle_sandbox" name="paddle_sandbox" class="form-select" data-placeholder="<?php echo e(__('Enable/Disable Paddle Sandbox')); ?>:">			
													<option value=true <?php if(config('services.paddle.sandbox')  == true): ?> selected <?php endif; ?>><?php echo e(__('Enable')); ?></option>
													<option value=false <?php if(config('services.paddle.sandbox')  == false): ?> selected <?php endif; ?>><?php echo e(__('Disable')); ?></option>
												</select>
												<?php $__errorArgs = ['paddle_sandbox'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('paddle_sandbox')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
									</div>
		
								</div>
							</div>


							<div class="card border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/iyzico.svg')); ?>" alt="Midtrans" class="gateway-logo"><span class="text-primary">Iyzico</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-iyzico" class="custom-switch-input" <?php if(config('services.iyzico.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Iyzico Prepaid</span>
												</label>
											</div>
										</div>
										
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">
											<!-- SECRET ACCESS KEY -->
											<div class="input-box">								
												<h6>Iyzico API Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['iyzico_api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="iyzico_api_key" name="iyzico_api_key" value="<?php echo e(config('services.iyzico.api_key')); ?>" autocomplete="off">
												</div>
												<?php $__errorArgs = ['iyzico_api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('iyzico_api_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END SECRET ACCESS KEY -->
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Iyzico Secret Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['iyzico_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="iyzico_secret_key" name="iyzico_secret_key" value="<?php echo e(config('services.iyzico.secret_key')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['iyzico_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('iyzico_secret_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>										

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Iyzico Sandbox <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<select id="iyzico_sandbox" name="iyzico_sandbox" class="form-select">			
													<option value=1 <?php if(config('services.iyzico.sandbox')  == true): ?> selected <?php endif; ?>><?php echo e(__('Enable')); ?></option>
													<option value=0 <?php if(config('services.iyzico.sandbox')  == false): ?> selected <?php endif; ?>><?php echo e(__('Disable')); ?></option>
												</select>
												<?php $__errorArgs = ['iyzico_sandbox'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('iyzico_sandbox')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
									</div>
		
								</div>
							</div>
		
		
							<div class="card border-0 special-shadow">							
								<div class="card-body">
		
									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/braintree.svg')); ?>" alt="Braintree" class="gateway-logo"><span class="text-primary">Braintree</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('Prepaid Plans')); ?>)</span></h6>
		
									<div class="row">
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-braintree" class="custom-switch-input" <?php if(config('services.braintree.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Braintree Prepaid</span>
												</label>
											</div>
										</div>
									</div>
		
									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Braintree Private Key</h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['braintree_private_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="braintree_private_key" name="braintree_private_key" value="<?php echo e(config('services.braintree.private_key')); ?>" autocomplete="off">
												</div>
													<?php $__errorArgs = ['braintree_private_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('braintree_private_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Braintree Public Key</h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['braintree_public_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="braintree_public_key" name="braintree_public_key" value="<?php echo e(config('services.braintree.public_key')); ?>" autocomplete="off">
												</div>
													<?php $__errorArgs = ['braintree_public_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('braintree_public_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>									
										<div class="col-lg-6 col-md-6 col-sm-12">		
											<div class="input-box">								
												<h6>Braintree Merchant ID</h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['braintree_merchant_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="braintree_merchant_id" name="braintree_merchant_id" value="<?php echo e(config('services.braintree.merchant_id')); ?>" autocomplete="off">
												</div>
													<?php $__errorArgs = ['braintree_merchant_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('braintree_merchant_id')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div>
										</div>
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Braintree Environment</h6> 
												<select id="braintree" name="braintree_env" class="form-select" data-placeholder="Choose Braintree Environment:">			
													<option value="sandbox" <?php if(config('services.braintree.env')  == 'sandbox'): ?> selected <?php endif; ?>>Sandbox</option>
													<option value="production" <?php if(config('services.braintree.env')  == 'production'): ?> selected <?php endif; ?>>Production</option>
												</select>
												<?php $__errorArgs = ['braintree_env'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('braintree_env')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
									</div>
		
								</div>
							</div>


							<div class="card border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/midtrans.png')); ?>" alt="Midtrans" class="gateway-logo"><span class="text-primary">Midtrans</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('Prepaid Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-midtrans" class="custom-switch-input" <?php if(config('services.midtrans.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Midtrans Prepaid</span>
												</label>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>Midtrans Server Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['midtrans_server_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="midtrans_server_key" name="midtrans_server_key" value="<?php echo e(config('services.midtrans.server_key')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['midtrans_server_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('midtrans_server_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<!-- SECRET ACCESS KEY -->
											<div class="input-box">								
												<h6>Midtrans Client Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['midtrans_client_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="midtrans_client_key" name="midtrans_client_key" value="<?php echo e(config('services.midtrans.client_key')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['midtrans_client_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('midtrans_client_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END SECRET ACCESS KEY -->
										</div>	
										
										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Midtrans Merchant ID <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['midtrans_merchant_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="midtrans_merchant_id" name="midtrans_merchant_id" value="<?php echo e(config('services.midtrans.merchant_id')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['midtrans_merchant_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('midtrans_merchant_id')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>Midtrans Production <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<select id="midtrans-production" name="midtrans-production" class="form-select" data-placeholder="<?php echo e(__('Enable/Disable Midtrans Production')); ?>:">			
													<option value=true <?php if(config('services.midtrans.production')  == true): ?> selected <?php endif; ?>><?php echo e(__('Enable')); ?></option>
													<option value=false <?php if(config('services.midtrans.production')  == false): ?> selected <?php endif; ?>><?php echo e(__('Disable')); ?></option>
												</select>
												<?php $__errorArgs = ['midtrans-production'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('midtrans-production')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
									</div>
		
								</div>
							</div>

							<div class="card border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/2checkout.webp')); ?>" alt="2Checkout" class="gateway-logo"><span class="text-primary">2Checkout</span> <?php echo e(__('Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-2checkout" class="custom-switch-input" <?php if(config('services.2checkout.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use 2Checkout Prepaid</span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-2checkout-subscription" class="custom-switch-input" <?php if(config('services.2checkout.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use 2Checkout Subscription</span>
												</label>
											</div>
									</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">
											<!-- SECRET ACCESS KEY -->
											<div class="input-box">								
												<h6>2Checkout Merchant Code<span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['2checkout_merchant_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="2checkout_merchant_code" name="2checkout_merchant_code" value="<?php echo e(config('services.2checkout.merchant_code')); ?>" autocomplete="off">
												</div>
												<?php $__errorArgs = ['2checkout_merchant_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('2checkout_merchant_code')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END SECRET ACCESS KEY -->
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">								
											<!-- ACCESS KEY -->
											<div class="input-box">								
												<h6>2Checkout Secret Key <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['2checkout_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="2checkout_secret_key" name="2checkout_secret_key" value="<?php echo e(config('services.2checkout.secret_key')); ?>" autocomplete="off">
												</div> 
												<?php $__errorArgs = ['2checkout_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('2checkout_secret_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> <!-- END ACCESS KEY -->
										</div>										

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6>2Checkout Sandbox <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<select id="2checkout_sandbox" name="2checkout_sandbox" class="form-select">			
													<option value=true <?php if(config('services.2checkout.sandbox')  == true): ?> selected <?php endif; ?>><?php echo e(__('Enable')); ?></option>
													<option value=false <?php if(config('services.2checkout.sandbox')  == false): ?> selected <?php endif; ?>><?php echo e(__('Disable')); ?></option>
												</select>
												<?php $__errorArgs = ['2checkout_sandbox'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('2checkout_sandbox')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>
										
									</div>
		
								</div>
							</div>

						</div>
					</div>


					<div class="card border-0">
						<div class="card-header">
							<h3 class="card-title"><span class="text-info"><?php echo e(__('Cryptocurrency')); ?> </span> <?php echo e(__('Payment')); ?></h3>
						</div>
						<div class="card-body pb-6">
		
							<div class="card overflow-hidden border-0 special-shadow">							
								<div class="card-body">
		
									<h6 class="fs-12 font-weight-bold mb-4"><img src="<?php echo e(URL::asset('/img/payments/coinbase.svg')); ?>" alt="Coinbase" class="gateway-logo"><?php echo e(__('Coinbase Commerce Payment Gateway')); ?> <span class="text-primary">(<?php echo e(__('Prepaid Plans')); ?>)</span></h6>
		
									<div class="row">
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-coinbase" class="custom-switch-input" <?php if(config('services.coinbase.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description">Use Coinbase Prepaid</span>
												</label>
											</div>
										</div>
									</div>
		
									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">		
											<div class="input-box">								
												<h6>Coinbase API Key</h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['coinbase_api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="coinbase_api_key" name="coinbase_api_key" value="<?php echo e(config('services.coinbase.api_key')); ?>" autocomplete="off">
												</div>
													<?php $__errorArgs = ['coinbase_api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('coinbase_api_key')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div>
										</div>
										<div class="col-lg-6 col-md-6 col-sm-12">		
											<div class="input-box">								
												<h6>Coinbase Webhook Secret</h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['coinbase_webhook_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="coinbase_webhook_secret" name="coinbase_webhook_secret" value="<?php echo e(config('services.coinbase.webhook_secret')); ?>" autocomplete="off">
												</div>
													<?php $__errorArgs = ['coinbase_webhook_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('coinbase_webhook_secret')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div>
										</div>
										<div class="col-lg-6 col-md-6 col-sm-12">		
											<div class="input-box">								
												<h6>Coinbase Webhook URI</h6>
												<div class="form-group">							    
													<input type="text" class="form-control <?php $__errorArgs = ['coinbase_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="coinbase_webhook_uri" name="coinbase_webhook_uri" value="<?php echo e(config('services.coinbase.webhook_uri')); ?>" autocomplete="off">
												</div>
													<?php $__errorArgs = ['coinbase_webhook_uri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('coinbase_webhook_uri')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div>
										</div>
									</div>
		
								</div>
							</div>
						
						</div>					
					
					</div>


					<div class="card border-0">
						<div class="card-header">
							<h3 class="card-title"><span class="text-info"><?php echo e(__('Offline')); ?> </span> <?php echo e(__('Payment')); ?></h3>
						</div>
						<div class="card-body">

							<div class="card overflow-hidden border-0 special-shadow">							
								<div class="card-body">

									<h6 class="fs-12 font-weight-bold mb-4"><i class="fa-solid fa-money-check-dollar-pen fs-16 mr-2"></i><?php echo e(__('Bank Transfer Payment')); ?> <span class="text-primary">(<?php echo e(__('All Plans')); ?>)</span></h6>

									<div class="row">
										<div class="col-md-6 col-sm-12 mb-2">
											<div class="form-group">
												<label class="custom-switch">
													<input type="checkbox" name="enable-bank" class="custom-switch-input" <?php if(config('services.banktransfer.enable')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description"><?php echo e(__('Use Bank Transfer Prepaid')); ?></span>
												</label>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group mb-4">
												<label class="custom-switch">
													<input type="checkbox" name="enable-bank-subscription" class="custom-switch-input" <?php if(config('services.banktransfer.subscription')  == 'on'): ?> checked <?php endif; ?>>
													<span class="custom-switch-indicator"></span>
													<span class="custom-switch-description"><?php echo e(__('Use Bank Transfer Subscription')); ?></span>
												</label>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6 col-md-6 col-sm-12">								
											<div class="input-box">								
												<h6><?php echo e(__('Customer Payment Intructions')); ?> <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
												<textarea class="form-control" name="bank_instructions" id="bank_instructions" rows="6"><?php echo e($bank['bank_instructions']); ?></textarea> 
												<?php $__errorArgs = ['bank_instructions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('bank_instructions')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div>
										</div>

										<div class="col-lg-6 col-md-6 col-sm-12">
											<div class="input-box">								
												<h6><?php echo e(__('Bank Account Requisites')); ?> <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
												<textarea class="form-control" name="bank_requisites" id="bank_requisites" rows="6"><?php echo e($bank['bank_requisites']); ?></textarea>
												<?php $__errorArgs = ['bank_requisites'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<p class="text-danger"><?php echo e($errors->first('bank_requisites')); ?></p>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div> 
										</div>										
										
									</div>
		
								</div>
							</div>		
				

							<!-- SAVE CHANGES ACTION BUTTON -->
							<div class="border-0 text-right mb-2 mt-1">
								<a href="<?php echo e(route('admin.finance.dashboard')); ?>" class="btn btn-cancel mr-2"><?php echo e(__('Cancel')); ?></a>
								<button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>							
							</div>
						
						</div>					
					
					</div>		
				
				</form>
					
			</div>
		<?php endif; ?>
	</div>
	<!-- END ALL PAYMENT CONFIGURATIONS -->	

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/masoaico/test.mindwrite.ai/resources/views/admin/finance/settings/index.blade.php ENDPATH**/ ?>